IF EXISTS ( SELECT * FROM SYS.OBJECTS 
	WHERE NAME = 'P_REMOVE_DUPLICIDADES_EQUALS')
BEGIN 
	DROP PROCEDURE P_REMOVE_DUPLICIDADES_EQUALS
END
GO

CREATE PROCEDURE [dbo].[P_REMOVE_DUPLICIDADES_EQUALS] AS
BEGIN

	--DELETE FROM ReprocessamentoConciliacaoDias;

	WHILE EXISTS (select 1
					from [CONCILIACAO_CARTOES_LINX_CONCILIADOR]
					where DT_VENDA >= DATEADD(DD,-120, GETDATE())
					group by cd_filial, cd_grupo, dt_venda, nsu_rede, cd_autorizacao, vlr_bruto_rede, vlr_liquido_rede, nr_cartao_rede, nr_parcelas_rede
					having count(1) > 1)
	BEGIN


		CREATE TABLE #Tratamento (
			cd_filial INT, 
			cd_grupo INT, 
			dt_venda DATE, 
			nsu_rede VARCHAR(200), 
			cd_autorizacao VARCHAR(200), 
			vlr_bruto_rede MONEY, 
			vlr_liquido_rede MONEY, 
			nr_cartao_rede VARCHAR(50), 
			nr_parcelas_rede INT, 
			CD_CTR_manter INT
		)

		select c.*
		into #Principal --drop table #Principal
		from
		(
		select cd_filial, cd_grupo, dt_venda, nsu_rede, cd_autorizacao, vlr_bruto_rede, vlr_liquido_rede, nr_cartao_rede, nr_parcelas_rede
		from [CONCILIACAO_CARTOES_LINX_CONCILIADOR]
		where DT_VENDA >= DATEADD(DD,-120, GETDATE())
		group by cd_filial, cd_grupo, dt_venda, nsu_rede, cd_autorizacao, vlr_bruto_rede, vlr_liquido_rede, nr_cartao_rede, nr_parcelas_rede
		having count(1) > 1
		) dup
		INNER JOIN [CONCILIACAO_CARTOES_LINX_CONCILIADOR] c on dup.cd_filial = c.cd_filial
																and dup.cd_grupo = c.cd_grupo
																and dup.dt_venda = c.dt_venda
																and dup.nsu_rede = c. nsu_rede
																and dup.cd_autorizacao = c.cd_autorizacao
																and dup.vlr_bruto_rede = c. vlr_bruto_rede
																and dup.vlr_liquido_rede = c. vlr_liquido_rede
																and dup.nr_parcelas_rede = c. nr_parcelas_rede
																and dup.nr_cartao_rede = c.nr_cartao_rede


		--1ª regra - existe na pago, e estar conciliado, vou manter

		INSERT INTO ReprocessamentoConciliacaoDias
		SELECT DISTINCT CD_FILIAL, dt_venda
		FROM #Principal

		IF NOT EXISTS (SELECT 1 FROM #Tratamento)
		BEGIN

			INSERT INTO #Tratamento
			SELECT cd_filial, cd_grupo, dt_venda, nsu_rede, cd_autorizacao, vlr_bruto_rede, vlr_liquido_rede, nr_cartao_rede, nr_parcelas_rede, min(CD_CTR) as CD_CTR_manter
			FROM #Principal DUP
			WHERE EXISTS (SELECT 1 FROM [CONCILIACAO_CARTOES_LINX_CONCILIADOR_PagO] p
											where p.idt_lote = DUP.IDT_LOTE_REDE)
				AND EXISTS (SELECT 1 FROM [CONCILIACAO_CARTOES_FINAL] F WHERE F.CD_CTR_CONCILIADOR = DUP.CD_CTR)
			group by cd_filial, cd_grupo, dt_venda, nsu_rede, cd_autorizacao, vlr_bruto_rede, vlr_liquido_rede, nr_cartao_rede, nr_parcelas_rede
		END

		--2ª regra - existe na pgto, e estar conciliado, vou manter
		IF NOT EXISTS (SELECT 1 FROM #Tratamento)
		BEGIN
			INSERT INTO #Tratamento
			SELECT cd_filial, cd_grupo, dt_venda, nsu_rede, cd_autorizacao, vlr_bruto_rede, vlr_liquido_rede, nr_cartao_rede, nr_parcelas_rede, min(CD_CTR) as CD_CTR_manter
			FROM #Principal DUP
			WHERE EXISTS (SELECT 1 FROM [CONCILIACAO_CARTOES_LINX_CONCILIADOR_PgtO] p
											where p.idt_lote = DUP.IDT_LOTE_REDE)
				AND EXISTS (SELECT 1 FROM [CONCILIACAO_CARTOES_FINAL] F WHERE F.CD_CTR_CONCILIADOR = DUP.CD_CTR)
			group by cd_filial, cd_grupo, dt_venda, nsu_rede, cd_autorizacao, vlr_bruto_rede, vlr_liquido_rede, nr_cartao_rede, nr_parcelas_rede
		END

		--3ª regra - existe na pgto, vou manter
		IF NOT EXISTS (SELECT 1 FROM #Tratamento)
		BEGIN
			INSERT INTO #Tratamento
			SELECT cd_filial, cd_grupo, dt_venda, nsu_rede, cd_autorizacao, vlr_bruto_rede, vlr_liquido_rede, nr_cartao_rede, nr_parcelas_rede, min(CD_CTR) as CD_CTR_manter
			FROM #Principal DUP
			WHERE EXISTS (SELECT 1 FROM [CONCILIACAO_CARTOES_LINX_CONCILIADOR_PgtO] p
											where p.idt_lote = DUP.IDT_LOTE_REDE)
			group by cd_filial, cd_grupo, dt_venda, nsu_rede, cd_autorizacao, vlr_bruto_rede, vlr_liquido_rede, nr_cartao_rede, nr_parcelas_rede
		END

		print '4ª regra - existe na final, vamos manter'
		IF NOT EXISTS (SELECT 1 FROM #Tratamento)
		BEGIN
			INSERT INTO #Tratamento
			SELECT cd_filial, cd_grupo, dt_venda, nsu_rede, cd_autorizacao, vlr_bruto_rede, vlr_liquido_rede, nr_cartao_rede, nr_parcelas_rede, min(CD_CTR) as CD_CTR_manter
			FROM #Principal DUP
			WHERE EXISTS (SELECT 1 FROM [CONCILIACAO_CARTOES_FINAL] F WHERE F.CD_CTR_CONCILIADOR = DUP.CD_CTR)
			group by cd_filial, cd_grupo, dt_venda, nsu_rede, cd_autorizacao, vlr_bruto_rede, vlr_liquido_rede, nr_cartao_rede, nr_parcelas_rede
		END

		print '5ª regra - nenhuma das duas existem na final e nem na pgto, manter uma das duas'
		IF NOT EXISTS (SELECT 1 FROM #Tratamento)
		BEGIN
			INSERT INTO #Tratamento
			SELECT cd_filial, cd_grupo, dt_venda, nsu_rede, cd_autorizacao, vlr_bruto_rede, vlr_liquido_rede, nr_cartao_rede, nr_parcelas_rede, min(CD_CTR) as CD_CTR_manter
			FROM #Principal DUP
			group by cd_filial, cd_grupo, dt_venda, nsu_rede, cd_autorizacao, vlr_bruto_rede, vlr_liquido_rede, nr_cartao_rede, nr_parcelas_rede
		END

		print 'excluir '
		select C.*, DUP.CD_CTR_manter
		INTO #Excluir --DROP TABLE #Excluir
		from #Tratamento dup
		INNER JOIN [CONCILIACAO_CARTOES_LINX_CONCILIADOR] c 														
														ON dup.cd_filial = c.cd_filial
														and dup.cd_grupo = c.cd_grupo
														and dup.dt_venda = c.dt_venda 
														and dup.nsu_rede COLLATE DATABASE_DEFAULT = c. nsu_rede COLLATE DATABASE_DEFAULT
														and dup.cd_autorizacao COLLATE DATABASE_DEFAULT = c.cd_autorizacao COLLATE DATABASE_DEFAULT
														and dup.vlr_bruto_rede = c. vlr_bruto_rede
														and dup.vlr_liquido_rede = c. vlr_liquido_rede
														and dup.nr_parcelas_rede  = c. nr_parcelas_rede 
														and dup.nr_cartao_rede COLLATE DATABASE_DEFAULT = c.nr_cartao_rede COLLATE DATABASE_DEFAULT
		WHERE DUP.CD_CTR_manter <> C.CD_CTR



		/*Verificação MESCLAR/UPDATE de parcelas e pagamentos*/

		SELECT D.IDT_TRANSACAO, D.IDT_LOTE_REDE, MANTER.IDT_TRANSACAO AS IDT_TRANSACAO_CORRETA, MANTER.IDT_LOTE_REDE as IDT_LOTE_REDE_CORRETO, CD_CTR_manter, d.cd_filial
		INTO #JuncaoPagamentos --drop table #JuncaoPagamentos
		FROM #Excluir D
		INNER JOIN [CONCILIACAO_CARTOES_LINX_CONCILIADOR_PGTO] C on C.IDT_LOTE = D.IDT_LOTE_REDE
		INNER JOIN [CONCILIACAO_CARTOES_LINX_CONCILIADOR] MANTER ON MANTER.CD_CTR = D.CD_CTR_manter
		WHERE NOT EXISTS (SELECT 1 FROM [CONCILIACAO_CARTOES_LINX_CONCILIADOR_PGTO] PG
							WHERE PG.IDT_LOTE = MANTER.IDT_LOTE_REDE
							AND PG.PARCELA_LOTE = C.PARCELA_LOTE
							AND PG.CD_FILIAL = C.CD_FILIAL
							AND PG.VLR_BRUTO = C.VLR_BRUTO
						  )


		update M
		set idt_lote = IDT_LOTE_REDE_CORRETO,
			CD_CTR_LOTE = CD_CTR_manter
		FROM #JuncaoPagamentos D
		INNER JOIN [CONCILIACAO_CARTOES_LINX_CONCILIADOR_PGTO] C on C.IDT_LOTE = D.IDT_LOTE_REDE
		INNER JOIN CONCILIACAO_CARTOES_LINX_CONCILIADOR_PGTO_RC_ADM_CARTAO_MOV M ON M.IDT_LOTE = C.IDT_LOTE
																					AND M.PARCELA_LOTE = C.PARCELA_LOTE

		UPDATE C
		SET IDT_LOTE = J.IDT_LOTE_REDE_CORRETO
		FROM #JuncaoPagamentos J
		INNER JOIN [CONCILIACAO_CARTOES_LINX_CONCILIADOR_PGTO] C on C.IDT_LOTE = J.IDT_LOTE_REDE




		UPDATE p
		SET IDT_TRANSACAO = D.IDT_TRANSACAO_CORRETA
		FROM #JuncaoPagamentos d
		INNER JOIN CONCILIACAO_CARTOES_LINX_CONCILIADOR_parc p on p.IDT_TRANSACAO = d.IDT_TRANSACAO and p.cd_filial = d.cd_filial
		WHERE NOT EXISTS (SELECT 1 FROM CONCILIACAO_CARTOES_LINX_CONCILIADOR_parc P2
							where p2.IDT_TRANSACAO = D.IDT_TRANSACAO_CORRETA
							and p2.cd_filial = d.cd_filial
							and p2.NR_PARCELA = p.nr_parcela)


		/*FIM - Verificação MESCLAR/UPDATE de parcelas e pagamentos*/

		print'/*REMOVENDO REGISTROS DO CONCILIADOR*/'
		DELETE f 
		FROM #Excluir d
		INNER JOIN [dbo].[CONCILIACAO_CARTOES_FINAL] F on F.CD_CTR_CONCILIADOR = d.CD_CTR


		DELETE C 
		FROM #Excluir D
		INNER JOIN [CONCILIACAO_CARTOES_LINX_CONCILIADOR] C on C.CD_CTR = D.CD_CTR

		print'REMOVENDO REGISTROS DA PGTO*/'

		DELETE M
		FROM #Excluir D
		INNER JOIN [CONCILIACAO_CARTOES_LINX_CONCILIADOR_PGTO] C on C.IDT_LOTE = D.IDT_LOTE_REDE
		INNER JOIN CONCILIACAO_CARTOES_LINX_CONCILIADOR_PGTO_RC_ADM_CARTAO_MOV M ON M.IDT_LOTE = C.IDT_LOTE
																					AND M.PARCELA_LOTE = C.PARCELA_LOTE


		DELETE C
		FROM #Excluir D
		INNER JOIN [CONCILIACAO_CARTOES_LINX_CONCILIADOR_PGTO] C on C.IDT_LOTE = D.IDT_LOTE_REDE


		print'REMOVENDO REGISTROS DO PROPRIO LOTE*/'


		DELETE C
		FROM #Excluir D
		INNER JOIN [CONCILIACAO_CARTOES_LINX_CONCILIADOR_lote] C on C.IDT_LOTE = d.IDT_LOTE_REDE
		where not exists( select 1 from CONCILIACAO_CARTOES_LINX_CONCILIADOR_AJUSTE a where a.idt_lote = c.IDT_LOTE)



		DELETE p
		FROM #Excluir d
		INNER JOIN CONCILIACAO_CARTOES_LINX_CONCILIADOR_parc p on p.IDT_TRANSACAO = d.IDT_TRANSACAO and p.cd_filial = d.cd_filial


		print'Limpa tabelas*/'

		DROP TABLE #Excluir;
		DROP TABLE #Tratamento;
		DROP TABLE #Principal;
		DROP TABLE #JuncaoPagamentos;

	END
END
